<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Pengumuman Kelulusan') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

  <style>
    .sidebar { width: 280px; min-height: 100vh; overflow-y: auto; }
    .sidebar a { text-decoration: none; }
    .sidebar .active { background: rgba(13,110,253,.12); border-radius: .5rem; }
    .sub-menu { padding-left: 1rem; }
    .sub-menu .list-group-item {
      font-size: 0.9rem;
      padding: 0.5rem 1rem;
      border: none;
    }
    .menu-toggle {
      cursor: pointer;
      position: relative;
    }
    .menu-toggle::after {
      content: '▼';
      position: absolute;
      right: 1rem;
      font-size: 0.75rem;
      transition: transform 0.3s;
    }
    .menu-toggle.collapsed::after {
      transform: rotate(-90deg);
    }

    /* ============================
       TAMBAHAN STYLE (TAMPILAN SAJA)
       TANPA UBAH KODE DALAM FILE
       ============================ */

    /* area konten kanan */
    .content-area {
      width: 100%;
      padding: 24px;
    }

    /* rapikan judul */
    .content-area h1 {
      font-size: 26px;
      font-weight: 800;
      color: #0f172a;
      margin-bottom: 6px;
    }

    /* tombol action (link dalam <p>) */
    .content-area p a {
      display: inline-block;
      background: #2563eb;
      color: #fff !important;
      padding: 8px 14px;
      border-radius: 10px;
      font-size: 13px;
      font-weight: 700;
      text-decoration: none;
      transition: .2s ease;
    }
    .content-area p a:hover {
      background: #1d4ed8;
      text-decoration: none;
    }

    /* form reset */
    .content-area form input[type="text"] {
      padding: 8px 12px;
      border-radius: 10px;
      border: 1px solid #cbd5e1;
      font-size: 13px;
      outline: none;
    }
    .content-area form input[type="text"]:focus {
      border-color: #2563eb;
    }

    /* table tampil modern tanpa ubah atribut border bawaan */
    .content-area table {
      background: #fff;
      border-radius: 14px;
      overflow: hidden;
      box-shadow: 0 10px 25px rgba(0,0,0,.08);
      border: none;
    }

    /* header table */
    .content-area table thead th {
      background: #f8fafc;
      font-size: 13px;
      font-weight: 800;
      color: #334155;
      border-bottom: 1px solid #e2e8f0;
    }

    /* body table */
    .content-area table tbody td {
      font-size: 14px;
      color: #0f172a;
      border-bottom: 1px solid #f1f5f9;
      vertical-align: middle;
    }

    .content-area table tbody tr:hover {
      background: #f9fafb;
    }

    /* link aksi dalam tabel */
    .content-area table a {
      color: #2563eb;
      font-weight: 700;
      text-decoration: none;
    }
    .content-area table a:hover {
      text-decoration: underline;
    }

    /* pager */
    .content-area .pagination a,
    .content-area .pagination span {
      display: inline-block;
      padding: 6px 12px;
      margin: 2px;
      border-radius: 8px;
      background: #f1f5f9;
      color: #334155;
      text-decoration: none;
      font-size: 13px;
      font-weight: 700;
    }
    .content-area .pagination a:hover {
      background: #2563eb;
      color: #fff;
    }
      /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
      .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 768px) {
  .content-area {
    padding: 16px 14px; /* kiri-kanan lebih lega */
  }
}
@media (max-width: 768px) {
  .content-area p {
    display: flex;
    flex-direction: column;
    gap: 10px;
    margin-bottom: 14px;
  }

  .content-area p a {
    width: 100%;
    text-align: center;
  }
}
@media (max-width: 768px) {
  .content-area form input[type="text"] {
    width: 100%;
    margin-bottom: 10px;
  }
}
@media (max-width: 768px) {
  .content-area table {
    min-width: 600px;
  }

  .content-area {
    overflow-x: auto;
  }
}

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>


  <!-- ============================
       KONTEN KANAN (FILE KELULUSAN ASLI)
       TIDAK DIHAPUS / TIDAK DIUBAH FITURNYA
       ============================ -->
  <main class="content-area">

<h1><?= esc($title ?? 'Kelulusan') ?></h1> 

<?php if ($msg = session()->getFlashdata('success')): ?>
  <div style="padding:10px;background:#d1fae5;border:1px solid #34d399;border-radius:10px;margin:10px 0;">
    <?= esc($msg) ?>
  </div>
<?php endif; ?>

<?php if ($errs = session()->getFlashdata('errors')): ?>
  <div style="padding:10px;background:#fee2e2;border:1px solid #f87171;border-radius:10px;margin:10px 0;">
    <ul style="margin:0;padding-left:18px;">
      <?php foreach ((array)$errs as $e): ?>
        <li><?= esc($e) ?></li>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>

<p style="margin:12px 0;">
  <a href="<?= site_url('admin/kelulusan/import') ?>">+ Import Data (CSV)</a>
  &nbsp;|&nbsp;
  <a href="<?= site_url('admin/kelulusan/upload-skl') ?>">+ Upload PDF SKL (ZIP)</a>
</p>
<form action="<?= site_url('admin/kelulusan/reset') ?>" method="post" style="margin:12px 0;">
  <?= csrf_field() ?>
  <input type="text" name="tahun" placeholder="Tahun yang direset (contoh 2025/2026)" style="width:220px;">
  <button type="submit"
          onclick="return confirm('Yakin reset data kelulusan untuk tahun ini? Data akan dihapus!');"
          style="background:#b91c1c;color:#fff;border:none;padding:8px 12px;border-radius:8px;cursor:pointer;">
    Reset Data Tahun Ini
  </button>
</form>

<?php
// fleksibel: controller bisa kirim $items atau $rows
$data = $items ?? ($rows ?? []);
?>

<table border="1" cellpadding="8" cellspacing="0" width="100%">
  <thead>
    <tr>
      <th>Tahun</th>
      <th>NISN</th>
      <th>Nama</th>
      <th>Kelas</th>
      <th>Status</th>
      <th>PDF</th>
      <th>Aksi</th>

    </tr>
  </thead>
  <tbody>
    <?php if (empty($data)): ?>
      <tr><td colspan="7">Belum ada data.</td></tr>
    <?php else: ?>
      <?php foreach ($data as $r): ?>
        <?php
          // pdf_url / pdf_exists dari controller (atau fallback pdf_skl)
          $hasPdf = !empty($r['pdf_exists']) || !empty($r['pdf_url']);
          if (!$hasPdf && !empty($r['pdf_skl'])) $hasPdf = true;
        ?>
        <tr>
          <td><?= esc($r['tahun'] ?? '-') ?></td>
          <td><?= esc($r['nisn'] ?? '-') ?></td>
          <td><?= esc($r['nama'] ?? '-') ?></td>
          <td><?= esc($r['kelas'] ?? '-') ?></td>
          <td><?= esc($r['status'] ?? '-') ?></td>

          <td>
            <?php if ($hasPdf): ?>
              ✅ Ada
              <?php if (!empty($r['pdf_url'])): ?>
                &nbsp;|&nbsp;<a href="<?= esc($r['pdf_url']) ?>" target="_blank">Lihat</a>
                &nbsp;|&nbsp;<a href="<?= esc($r['pdf_url']) ?>" download>Download</a>
              <?php endif; ?>
            <?php else: ?>
              ❌ Belum ada
            <?php endif; ?>
          </td>

          <td>
            <?php if (!empty($r['id'])): ?>
              <a href="<?= site_url('admin/kelulusan/upload-skl/' . $r['id']) ?>">Upload/Ganti PDF</a>

              <?php if ($hasPdf): ?>
                &nbsp;|&nbsp;

                <!-- Tombol Hapus PDF -->
                <form action="<?= site_url('admin/kelulusan/delete-pdf/' . $r['id']) ?>"
                      method="post"
                      style="display:inline;"
                      onsubmit="return confirm('Yakin hapus PDF SKL untuk <?= esc($r['nama'] ?? '') ?> (<?= esc($r['nisn'] ?? '') ?>)?');">
                  <?= csrf_field() ?>
                  <button type="submit"
                          style="color:#b91c1c;background:none;border:none;cursor:pointer;padding:0;text-decoration:underline;">
                    Hapus PDF
                  </button>
                </form>
              <?php endif; ?>

            <?php else: ?>
              -
            <?php endif; ?>
          </td>
        </tr>
      <?php endforeach; ?>
    <?php endif; ?>
  </tbody>
</table>

<?php if (!empty($pager)): ?>
  <div style="margin-top:12px;"><?= $pager->links() ?></div>
<?php endif; ?>

  </main>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  function toggleSidebar() {
    document.getElementById('sidebar').classList.toggle('show');
    document.querySelector('.sidebar-overlay').classList.toggle('show');
  }
</script>
</body>
</html>
